/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Cache;
import cds.aladin.MyInputStream;
import cds.allsky.Context;
import cds.allsky.MyInputStreamCachedException;
import cds.fits.HeaderFits;
import cds.fits.UtilFits;
import cds.image.Bzip2;
import cds.tools.Util;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public class MyInputStreamCached
extends MyInputStream {
    private static long DEFAULTLIMIT = 512000L;
    private String nameInCache = null;
    public static Context context = null;
    private int[] hdu = null;
    private static HashMap<String, Integer> activeFile = new HashMap();
    static Object lock = new Object();
    private static File cachedir = null;
    private static double cacheSize = 0.0;
    private static long cacheLimit = DEFAULTLIMIT;
    private static int TEMP_DIR_ATTEMPTS = 10000;

    public MyInputStreamCached(String filename) throws Exception {
        super(new FileInputStream(filename));
        this.filename = filename;
    }

    public MyInputStreamCached(String filename, int[] hdu) throws Exception {
        super(new FileInputStream(filename));
        this.filename = filename;
        this.hdu = hdu;
    }

    private MyInputStreamCached(InputStream in, long type, String filename) {
        super(in, type, true);
        this.filename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MyInputStream startRead() throws IOException, Exception, MyInputStreamCachedException {
        long type = this.getType(10000);
        if ((type & 0x8080000020L) == 0L) {
            return this;
        }
        Object object = lock;
        synchronized (object) {
            if ((type & 0x8000000020L) != 0L) {
                return this.convertGZorBzip2(type);
            }
            if ((type & 0x80000000L) != 0L) {
                return this.convertFitsCmp();
            }
        }
        throw new MyInputStreamCachedException("Compression mode not implemented yet!");
    }

    private String getTargetName() {
        return MyInputStreamCached.getTargetName(this.filename);
    }

    private static String getTargetName(String filename) {
        return Cache.codage(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyInputStream convertGZorBzip2(long type) throws Exception, MyInputStreamCachedException {
        File dir = MyInputStreamCached.getCacheDir();
        this.nameInCache = this.getTargetName();
        File file = new File(dir.getCanonicalPath() + Util.FS + this.nameInCache);
        if (!file.exists()) {
            MyInputStreamCached.checkCache((double)(new File(this.filename).length() / 1024L) / 341.3333333333333);
            InputStream in = null;
            OutputStream out = null;
            try {
                int n;
                in = (type & 0x20L) != 0L ? new GZIPInputStream(this) : new Bzip2(this);
                out = new FileOutputStream(file);
                byte[] buf = new byte[512];
                long size = 0L;
                while ((n = in.read(buf)) >= 0) {
                    size += (long)n;
                    out.write(buf, 0, n);
                }
                cacheSize += (double)(size / 1024L) / 1024.0;
            }
            finally {
                in.close();
                out.close();
            }
        }
        return new MyInputStreamCached((InputStream)new FileInputStream(file), type, this.filename);
    }

    private MyInputStream convertFitsCmp() throws Exception, MyInputStreamCachedException {
        File dir = MyInputStreamCached.getCacheDir();
        this.nameInCache = this.getTargetName();
        String targetFile = dir.getCanonicalPath() + Util.FS + this.nameInCache;
        File file = new File(targetFile);
        HeaderFits emptyHDU = new HeaderFits();
        emptyHDU.setKeyValue("XTENSION", "IMAGE");
        emptyHDU.setKeyValue("BITPIX", "8");
        emptyHDU.setKeyValue("NAXIS", "0");
        emptyHDU.setKeyValue("PCOUNT", "0");
        emptyHDU.setKeyValue("GCOUNT", "1");
        if (!file.exists()) {
            MyInputStreamCached.checkCache((double)(new File(this.filename).length() / 1024L) / 341.3333333333333);
            HeaderFits header = new HeaderFits(this);
            FileOutputStream out = null;
            try {
                long n;
                out = new FileOutputStream(file);
                long size = header.writeHeader(out);
                int nDone = 0;
                int nhdu = 1;
                while (true) {
                    boolean flagskip = false;
                    if (this.hdu != null && this.hdu[0] != -1) {
                        flagskip = true;
                        for (int h : this.hdu) {
                            if (h != nhdu) continue;
                            flagskip = false;
                            break;
                        }
                    }
                    if ((n = this.writeFitsCmp(out, this, flagskip)) == -1L || this.hdu == null || this.hdu[0] != -1 && nDone == this.hdu.length) break;
                    if (n == 0L) {
                        n = emptyHDU.writeHeader(out);
                    } else {
                        ++nDone;
                    }
                    size += n;
                    ++nhdu;
                }
                cacheSize += (double)((size += n) / 1024L) / 1024.0;
            }
            catch (Exception e) {
                ((OutputStream)out).close();
                out = null;
                file.delete();
                throw e;
            }
            finally {
                this.close();
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        return new MyInputStreamCached((InputStream)new FileInputStream(file), 0x80000000L, this.filename);
    }

    protected long writeFitsCmp(OutputStream os, MyInputStream dis, boolean flagskip) throws Exception {
        long size;
        try {
            HeaderFits inHeader = new HeaderFits(dis);
            HeaderFits outHeader = new HeaderFits();
            byte[] buf = UtilFits.uncompress(outHeader, inHeader, dis, flagskip);
            long pos = this.getPos();
            if (pos % 2880L != 0L) {
                long off = (pos / 2880L + 1L) * 2880L - pos;
                this.skip(off);
            }
            if (!flagskip) {
                size = outHeader.writeHeader(os);
                os.write(buf);
                os.write(MyInputStreamCached.getBourrage(size += (long)buf.length));
            } else {
                size = 0L;
            }
        }
        catch (EOFException e0) {
            return -1L;
        }
        return size;
    }

    public static byte[] getBourrage(long currentPos) {
        int n = (int)(currentPos % 2880L);
        int size = n == 0 ? 0 : 2880 - n;
        byte[] b = new byte[size];
        return b;
    }

    private static void checkCache(double size) throws Exception, MyInputStreamCachedException {
        if (cacheSize + size < (double)cacheLimit) {
            return;
        }
        File dir = MyInputStreamCached.getCacheDir();
        File[] files = dir.listFiles();
        double rmSize = 0.0;
        int n = 0;
        for (File f : files) {
            if (MyInputStreamCached.stillActive(f)) continue;
            rmSize += (double)(f.length() / 1024L) / 1024.0;
            f.delete();
            ++n;
            if (!(cacheSize - rmSize < (double)(cacheLimit / 3L * 2L))) continue;
            cacheSize -= rmSize;
            if (context != null) {
                context.info("Disk cache flushed (" + n + " file" + (n > 1 ? "s" : "") + "/" + Util.getUnitDisk(rmSize + "MB") + " released) => " + MyInputStreamCached.getCacheInfo());
            }
            return;
        }
        if (context != null) {
            context.abort("Cache disk overflow ! " + cachedir + " => " + MyInputStreamCached.getCacheInfo());
        }
        throw new MyInputStreamCachedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean stillActive(File f) throws Exception {
        String filename = f.getCanonicalPath();
        int i = filename.lastIndexOf(Util.FS);
        String nameInCache = filename.substring(i + 1);
        Object object = lock;
        synchronized (object) {
            Integer n = activeFile.get(nameInCache);
            return n != null && n > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incActiveFile(String filenameOrig) {
        String f = MyInputStreamCached.getTargetName(filenameOrig);
        Object object = lock;
        synchronized (object) {
            Integer nbActive = activeFile.get(f);
            int n = nbActive == null ? 1 : nbActive + 1;
            activeFile.put(f, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decActiveFile(String filenameOrig) {
        String f = MyInputStreamCached.getTargetName(filenameOrig);
        Object object = lock;
        synchronized (object) {
            Integer nbActive = activeFile.get(f);
            if (nbActive == null) {
                return;
            }
            int n = nbActive - 1;
            if (n <= 0) {
                activeFile.remove(f);
            } else {
                activeFile.put(f, n);
            }
        }
    }

    public static String getCacheInfo() throws Exception {
        return MyInputStreamCached.getCacheInfo(1);
    }

    public static String getCacheInfo(int mode) throws Exception {
        if (cachedir == null) {
            return null;
        }
        if (mode == 0) {
            return cachedir.getAbsolutePath();
        }
        if (cacheSize == 0.0) {
            return null;
        }
        return Util.getUnitDisk((long)cacheSize + "MB") + "/" + Util.getUnitDisk(cacheLimit + "MB");
    }

    public static void setCache(File dir) throws Exception {
        MyInputStreamCached.setCache(dir, DEFAULTLIMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCache(File dir, long sizeLimit) throws Exception {
        Object object = lock;
        synchronized (object) {
            if (cachedir != null) {
                throw new Exception("Cache dir already in use [" + cachedir.getCanonicalPath() + "]");
            }
            cachedir = dir;
            cacheLimit = sizeLimit == -1L ? DEFAULTLIMIT : sizeLimit;
            cacheSize = 0.0;
            if (cachedir == null || !cachedir.exists()) {
                return;
            }
            File[] files = cachedir.listFiles();
            if (files != null) {
                for (File f : files) {
                    cacheSize += (double)(f.length() / 1024L) / 1024.0;
                }
                MyInputStreamCached.setCacheSize(cacheLimit);
            }
            if (context != null) {
                context.info("Cache disk reused: " + cachedir.getAbsolutePath() + " (max size: " + Util.getUnitDisk(cacheLimit + "MB") + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCache() {
        Object object = lock;
        synchronized (object) {
            if (cachedir == null) {
                return;
            }
            double rmSize = 0.0;
            int n = 0;
            File[] files = cachedir.listFiles();
            if (files != null) {
                for (File f : files) {
                    rmSize += (double)(f.length() / 1024L) / 1024.0;
                    ++n;
                    f.delete();
                }
            }
            cachedir.delete();
            try {
                if (context != null) {
                    context.info("Cache disk removed: " + cachedir.getAbsolutePath() + " (" + n + " file" + (n > 1 ? "s" : "") + "=" + Util.getUnitDisk((long)rmSize + "MB") + ")!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cachedir = null;
            cacheSize = 0.0;
            cacheLimit = DEFAULTLIMIT;
            activeFile = new HashMap();
        }
    }

    public static boolean stillActive() {
        File[] files;
        if (cachedir == null) {
            return false;
        }
        boolean rep = false;
        for (File f : files = cachedir.listFiles()) {
            try {
                if (!MyInputStreamCached.stillActive(f)) continue;
                rep = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCacheSize(long sizeLimit) throws Exception {
        Object object = lock;
        synchronized (object) {
            cacheLimit = sizeLimit;
            MyInputStreamCached.checkCache(0.0);
        }
    }

    public static File getCacheDir() throws Exception {
        boolean flagCreate = false;
        if (cachedir == null) {
            cachedir = MyInputStreamCached.createTempDir();
            flagCreate = true;
        } else if (!cachedir.exists() && !(flagCreate = cachedir.mkdirs())) {
            throw new MyInputStreamCachedException("Cache disk creation error (" + cachedir.getAbsolutePath() + ")");
        }
        if (flagCreate) {
            long freeSpace = cachedir.getFreeSpace();
            if (freeSpace < 0L) {
                freeSpace = Long.MAX_VALUE;
                context.warning("Cache disk partition estimation overflow (too large for java) => assuming " + Util.getUnitDisk(cacheLimit));
            }
            if ((freeSpace /= 0x100000L) < cacheLimit) {
                long newsize = 3L * (freeSpace / 5L);
                String s = "Cache disk: not enough space on partition for " + Util.getUnitDisk(cacheLimit + "MB") + " => assume " + Util.getUnitDisk(newsize + "MB");
                if (context != null) {
                    context.warning(s);
                } else {
                    System.err.println(s);
                }
                cacheLimit = newsize;
            }
            if (context != null) {
                context.info("Cache disk created: " + cachedir.getAbsolutePath() + " (max size: " + Util.getUnitDisk(cacheLimit + "MB") + ")");
            }
        }
        return cachedir;
    }

    public static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < TEMP_DIR_ATTEMPTS; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within " + TEMP_DIR_ATTEMPTS + " attempts (tried " + baseName + "0 to " + baseName + (TEMP_DIR_ATTEMPTS - 1) + ')');
    }
}

